﻿#!/usr/bin/perl
use utf8;
die "Syntax: $0 <region_code>\nDon't forget to redirect console output!\n" if $ARGV[0] !~ /^([A-Z0-9]{2}|\w+\.txt)$/;
$fzip = $filename = $ARGV[0] =~ /^\w+\.txt$/ ? $ARGV[0] : 'ch.txt';
$fzip =~ s/txt/zip/;
die "You need $filename to proceed.\nDownload it from http://earth-info.nga.mil/gns/html/cntyfile/$fzip\n" unless -e -f $filename;
$region = $filename eq 'ch.txt' ? $ARGV[0] : '*';

open GNS, "<:utf8", $filename or die "Cannot open GNS file: $!\n";
chomp($header = <GNS>);
@fields = split /\t/, $header;
dsg();
while(<GNS>) {
	chomp;
	@gns1 = split /\t/;
	$gns{$fields[$_]} = $gns1[$_] foreach 0 .. $#fields;
	next if $region ne '*' && $gns{ADM1} ne $region;
	$pk = "$gns{LAT},$gns{LONG},$gns{DSG}";
	$pl = exists($places{$pk}) ? $places{$pk} : {};
#	$$pl{"gns:ufi"} = $gns{UFI};
	$$pl{lat1} = $gns{LAT};
	$$pl{lon1} = $gns{LONG};
	$$pl{time1} = "$gns{MODIFY_DATE}T00:00:00Z";
	$$pl{'gns:dsg'} = "$gns{DSG}: $dsg{$gns{DSG}}" if $gns{FC} ne 'P';
	if( $gns{FC} eq 'P' ) { $$pl{place} = 'village'; }
	elsif( $gns{FC} eq 'R' ) { $$pl{highway} = 'name'; }
	elsif( $gns{DSG} eq 'ISL' ) { $$pl{place} = 'island'; }
	elsif( $gns{DSG} eq 'PPLA3' ) { $$pl{place} = 'city'; }
	elsif( $gns{DSG} eq 'PPLA4' ) { $$pl{place} = 'town'; }
	elsif( $gns{DSG} eq 'BAY' ) { $$pl{natural} = 'bay'; }
	elsif( $gns{FC} eq 'T' ) { $$pl{natural} = 'peak'; }
	elsif( $gns{DSG} eq 'MRSH' ) { $$pl{natural} = 'wetland'; }
	elsif( $gns{FC} eq 'H' ) { $$pl{natural} = 'water'; }
	elsif( $gns{FC} eq 'V' ) { $$pl{natural} = 'wood'; }
	elsif( $gns{FC} eq 'A' ) { $$pl{place} = 'region'; }
	elsif( $gns{FC} eq 'L' ) { $$pl{place} = 'locality'; }
	# now processing spot features
	elsif( $gns{DSG} eq 'MKT' ) { $$pl{amenity} = 'marketplace'; }
	elsif( $gns{DSG} eq 'PKLT' ) { $$pl{amenity} = 'parking'; }
	elsif( $gns{DSG} eq 'PO' ) { $$pl{amenity} = 'post_office'; }
	elsif( $gns{DSG} eq 'GRVE' ) { $$pl{amenity} = 'grave_yard'; }
	elsif( $gns{DSG} eq 'VETF' ) { $$pl{amenity} = 'veterinary'; }
	elsif( $gns{DSG} eq 'BAN' ) { $$pl{amenity} = 'bank'; }
	elsif( $gns{DSG} eq 'DIP' ) { $$pl{amenity} = 'embassy'; }
	elsif( $gns{DSG} eq 'FIRE' ) { $$pl{amenity} = 'fire_station'; }
	elsif( $gns{DSG} eq 'MLWTR' ) { $$pl{man_made} = 'watermill'; }
	elsif( $gns{DSG} eq 'MLWND' ) { $$pl{man_made} = 'windmill'; }
	elsif( $gns{DSG} eq 'PIER' ) { $$pl{man_made} = 'pier'; }
	elsif( $gns{DSG} eq 'LTHSE' ) { $$pl{man_made} = 'lighthouse'; }
	elsif( $gns{DSG} eq 'TOWR' ) { $$pl{man_made} = 'tower'; }
	elsif( $gns{DSG} eq 'PS' ) { $$pl{power} = 'station'; }
	elsif( $gns{DSG} eq 'LDNG' ) { $$pl{leisure} = 'marina'; }
	elsif( $gns{DSG} eq 'RUIN' ) { $$pl{historic} = 'ruins'; }
	elsif( $gns{DSG} eq 'WEIR' ) { $$pl{waterway} = 'weir'; }
	elsif( $gns{DSG} eq 'ZOO' ) { $$pl{tourism} = 'zoo'; }
	elsif( $gns{DSG} eq 'RET' ) { $$pl{shop} = 'supermarket'; }
	elsif( $gns{DSG} eq 'SHOPC' ) { $$pl{shop} = 'mall'; }
	elsif( $gns{DSG} eq 'LNDF' ) { $$pl{landuse} = 'landfill'; }
	elsif( $gns{DSG} eq 'FRMS' ) { $$pl{place} = 'locality'; }
	elsif( $gns{DSG} =~ /^MN/ ) { $$pl{man_made} = 'mineshaft'; }
	elsif( $gns{DSG} =~ /^OB/ ) { $$pl{man_made} = 'survey_point'; }
	elsif( $gns{DSG} =~ /^OIL/ ) { $$pl{man_made} = 'petroleum_well'; }
	elsif( $gns{DSG} =~ /^MFG/ ) { $$pl{man_made} = 'works'; }
	elsif( $gns{DSG} =~ /^PRN/ ) { $$pl{amenity} = 'prison'; }
	elsif( $gns{DSG} =~ /^HSP/ ) { $$pl{amenity} = 'hospital'; }
	elsif( $gns{DSG} =~ /^SCH/ ) { $$pl{amenity} = 'college'; }
	elsif( $gns{DSG} =~ /^FY/ ) { $$pl{amenity} = 'ferry_terminal'; }
	elsif( $gns{DSG} =~ /^AIR/ ) { $$pl{aeroway} = 'aerodrome'; }
	elsif( $gns{DSG} =~ /^CMP/ ) { $$pl{tourism} = 'camp_site'; }
	elsif( $gns{DSG} =~ /^DCK/ ) { $$pl{waterway} = 'dock'; }
	elsif( $gns{DSG} =~ /^WALL/ ) { $$pl{barrier} = 'wall'; }
	elsif( $gns{DSG} =~ /^BLD/ ) { $$pl{building} = 'yes'; }
	elsif( $gns{DSG} =~ /^RSTN/ ) { $$pl{railway} = 'station'; }
	elsif( $gns{DSG} =~ /^RSTP/ ) { $$pl{railway} = 'halt'; }
	elsif( $gns{DSG} =~ /^SUB/ ) { $$pl{railway} = 'subway_entrance'; }
	# phew!
	else { $$pl{'gns:fc'} = $fc{$gns{FC}}; }
	$name = $gns{FULL_NAME_ND_RO};
# &#1057;&#1083;&#1077;&#1076;&#1091;&#1102;&#1097;&#1080;&#1077; &#1089;&#1090;&#1088;&#1086;&#1095;&#1082;&#1080; &#1087;&#1086;&#1074;&#1090;&#1086;&#1088;&#1103;&#1102;&#1090; &#1092;&#1091;&#1085;&#1082;&#1094;&#1080;&#1086;&#1085;&#1072;&#1083; cutreg.cs, &#1085;&#1086; &#1086;&#1085; &#1085;&#1077;&#1087;&#1088;&#1072;&#1074;&#1080;&#1083;&#1077;&#1085; (&#1054;&#1089;&#1090;. &#1055;&#1091;&#1085;&#1082;&#1090; 624 &#1050;&#1084;)
#	$name = lc $gns{FULL_NAME_ND_RO};
#	$name =~ s/(^|[ -])(\w)/\1\u\2/g;
	if( $gns{NT} eq 'NS' ) { $nkey = 'name'; }
	elsif( $gns{NT} eq 'VS' ) { $nkey = 'alt_name'; }
#	elsif( $gns{NT} eq 'V' ) { $nkey = 'alt_name:en'; }
	elsif( $gns{NT} eq 'HS' ) { $nkey = 'old_name'; }
	elsif( $gns{NT} eq 'H' ) { $nkey = 'old_name:en'; }
	elsif( $gns{NT} eq 'N' ) { $nkey = 'name:en'; }
	elsif( $gns{LC} eq 'zho' ) { $nkey = 'name'; }
	elsif( $gns{LC} eq 'uig' ) { $nkey = 'name:ug'; }
	elsif( $gns{LC} eq 'mon' ) { $nkey = 'name:mn'; }
	elsif( $gns{LC} eq 'rus' ) { $nkey = 'name:ru'; }
	else { $nkey = 'name:en'; }
	addname($pl, $nkey, $name);
#	addname($pl, "gns:nt:$gns{NT}", $name);
	$places{$pk} = $pl;
}
close GNS;

$id = 0;
binmode STDOUT, ":utf8";
print <<EOH;
<?xml version='1.0' encoding='UTF-8'?>
<osm version='0.6' upload='false' generator='GNS to OSM'>
EOH
for $pk (keys %places) {
	$gnsr = $places{$pk};
#	$$gnsr{name} =~ tr/aeoyckxABEO/&#1072;&#1077;&#1086;&#1091;&#1089;&#1082;&#1093;&#1040;&#1042;&#1045;&#1054;/ if exists($$gnsr{name}) && $$gnsr{name} =~ /[&#1072;-&#1103;]/;
	$$gnsr{name} = revtrans($$gnsr{'name:en'}) if !exists($$gnsr{name}) && exists($$gnsr{'name:en'});
	$$gnsr{'name:zh'} = $$gnsr{name} if exists($$gnsr{name}) && exists($$gnsr{'name:en'});
	$$gnsr{alt_name} = revtrans($$gnsr{'alt_name:en'}) if !exists($$gnsr{alt_name}) && exists($$gnsr{'alt_name:en'});
	$id--;
	print "<node id='$id' timestamp='$$gnsr{time1}' visible='true' lat='$$gnsr{lat1}' lon='$$gnsr{lon1}'>\n";
	print t('source:name', 'GNS');
#	print t('created_by', 'gns2osmr.pl');
	print t($_, $$gnsr{$_}) foreach grep !/\d$/, keys %{$gnsr};
	print "</node>\n";
}
print "</osm>";

sub t {
	($k, $v) = @_;
	$v =~ s/&/&amp;/g;
	$v =~ s/'/&apos;/g;
	$v =~ s/</&lt;/g;
	$v =~ s/>/&gt;/g;
	return "\t<tag k='$k' v='$v' />\n";
}

sub addname {
	($hr, $k, $v) = @_;
	$$hr{$k} = !exists $$hr{$k} ? $v : $$hr{$k} =~ /^(?:.+;)?$v(;.+)?$/ ? $$hr{$k} : "$$hr{$k};$v";
}

sub revtrans {
	return shift;
}

# ------------------------------------------------------- auto-generated with parse_dsg.pl

sub dsg {
	$dsg{AIRQ} = 'abandoned airfield';
	$dsg{CMPQ} = 'abandoned camp';
	$dsg{CNLQ} = 'abandoned canal';
	$dsg{MFGQ} = 'abandoned factory';
	$dsg{FRMQ} = 'abandoned farm';
	$dsg{MNQ} = 'abandoned mine';
	$dsg{MSSNQ} = 'abandoned mission';
	$dsg{OILQ} = 'abandoned oil well';
	$dsg{PPQ} = 'abandoned police post';
	$dsg{PPLQ} = 'abandoned populated place';
	$dsg{PRNQ} = 'abandoned prison';
	$dsg{RRQ} = 'abandoned railroad';
	$dsg{RSTNQ} = 'abandoned railroad station';
	$dsg{RSTPQ} = 'abandoned railroad stop';
	$dsg{STMQ} = 'abandoned watercourse';
	$dsg{WLLQ} = 'abandoned well';
	$dsg{ADMD} = 'administrative division';
	$dsg{ADMF} = 'administrative facility';
	$dsg{AGRC} = 'agricultural colony';
	$dsg{AGRF} = 'agricultural facility';
	$dsg{RESA} = 'agricultural reserve';
	$dsg{SCHA} = 'agricultural school';
	$dsg{AIRB} = 'airbase';
	$dsg{AIRF} = 'airfield';
	$dsg{AIRP} = 'airport';
	$dsg{AMTH} = 'amphitheater';
	$dsg{STMA} = 'anabranch';
	$dsg{ANCH} = 'anchorage';
	$dsg{RDA} = 'ancient road';
	$dsg{ANS} = 'ancient site';
	$dsg{WALLA} = 'ancient wall';
	$dsg{BLDA} = 'apartment building';
	$dsg{AQC} = 'aquaculture facility';
	$dsg{CNLA} = 'aqueduct';
	$dsg{ARCH} = 'arch';
	$dsg{LAND} = 'Arctic land';
	$dsg{AREA} = 'area';
	$dsg{ISLF} = 'artificial island';
	$dsg{ASPH} = 'asphalt lake';
	$dsg{ASTR} = 'astronomical station';
	$dsg{ASYL} = 'asylum';
	$dsg{ATHF} = 'athletic field';
	$dsg{ATOL} = 'atoll(s)';
	$dsg{CTRA} = 'atomic center';
	$dsg{BDLD} = 'badlands';
	$dsg{BSTN} = 'baling station';
	$dsg{ESTB} = 'banana plantation';
	$dsg{BNK} = 'bank(s)';
	$dsg{BAR} = 'bar';
	$dsg{BRKS} = 'barracks';
	$dsg{BTL} = 'battlefield';
	$dsg{BAY} = 'bay(s)';
	$dsg{RDGB} = 'beach ridge';
	$dsg{BCH} = 'beach(es)';
	$dsg{BCN} = 'beacon';
	$dsg{BNCH} = 'bench';
	$dsg{BGHT} = 'bight(s)';
	$dsg{BLHL} = 'blowhole(s)';
	$dsg{BLOW} = 'blowout(s)';
	$dsg{BTYD} = 'boatyard';
	$dsg{BOG} = 'bog(s)';
	$dsg{PSTB} = 'border post';
	$dsg{BLDR} = 'boulder field';
	$dsg{BP} = 'boundary marker';
	$dsg{BRKW} = 'breakwater';
	$dsg{MFGB} = 'brewery';
	$dsg{BDG} = 'bridge';
	$dsg{ZNB} = 'buffer zone';
	$dsg{BLDG} = 'building(s)';
	$dsg{BUR} = 'burial cave(s)';
	$dsg{CTRB} = 'business center';
	$dsg{BUTE} = 'butte(s)';
	$dsg{CARN} = 'cairn';
	$dsg{CLDA} = 'caldera';
	$dsg{CMP} = 'camp(s)';
	$dsg{CNL} = 'canal';
	$dsg{CNLB} = 'canal bend';
	$dsg{TNLC} = 'canal tunnel';
	$dsg{STMC} = 'canalized stream';
	$dsg{MFGC} = 'cannery';
	$dsg{CNYN} = 'canyon';
	$dsg{CAPE} = 'cape';
	$dsg{PPLC} = 'capital of a political entity';
	$dsg{RTE} = 'caravan route';
	$dsg{CSNO} = 'casino';
	$dsg{CSTL} = 'castle';
	$dsg{TNKD} = 'cattle dipping tank';
	$dsg{CSWY} = 'causeway';
	$dsg{CAVE} = 'cave(s)';
	$dsg{CMTY} = 'cemetery';
	$dsg{CHN} = 'channel';
	$dsg{MNCR} = 'chrome mine(s)';
	$dsg{CH} = 'church';
	$dsg{CRQ} = 'cirque(es)';
	$dsg{CLG} = 'clearing';
	$dsg{CFT} = 'cleft(s)';
	$dsg{CLF} = 'cliff(s)';
	$dsg{HSPC} = 'clinic';
	$dsg{MNC} = 'coal mine(s)';
	$dsg{COLF} = 'coalfield';
	$dsg{CST} = 'coast';
	$dsg{STNC} = 'coast guard station';
	$dsg{SCHC} = 'college';
	$dsg{COMC} = 'communication center';
	$dsg{CTRCM} = 'community center';
	$dsg{CNS} = 'concession area';
	$dsg{CONE} = 'cone(s)';
	$dsg{CNFL} = 'confluence';
	$dsg{CRSU} = 'continental rise';
	$dsg{CVNT} = 'convent';
	$dsg{MNCU} = 'copper mine(s)';
	$dsg{MFGCU} = 'copper works';
	$dsg{RFC} = 'coral reef(s)';
	$dsg{CRRL} = 'corral(s)';
	$dsg{CRDR} = 'corridor';
	$dsg{ESTC} = 'cotton plantation';
	$dsg{HSEC} = 'country house';
	$dsg{CTHSE} = 'courthouse';
	$dsg{COVE} = 'cove(s)';
	$dsg{LKC} = 'crater lake(s)';
	$dsg{CRTR} = 'crater(s)';
	$dsg{CUET} = 'cuesta(s)';
	$dsg{CULT} = 'cultivated area';
	$dsg{CRNT} = 'current';
	$dsg{CSTM} = 'customs checkpoint';
	$dsg{CUTF} = 'cutoff';
	$dsg{DARY} = 'dairy';
	$dsg{DAM} = 'dam';
	$dsg{DEPU} = 'deep';
	$dsg{DLTA} = 'delta';
	$dsg{PCLD} = 'dependent political entity';
	$dsg{DPR} = 'depression(s)';
	$dsg{DSRT} = 'desert';
	$dsg{PPLW} = 'destroyed populated place';
	$dsg{MNDT} = 'diatomite mine(s)';
	$dsg{DIKE} = 'dike';
	$dsg{DIP} = 'diplomatic facility';
	$dsg{STMD} = 'distributary(-ies)';
	$dsg{DTCH} = 'ditch';
	$dsg{DTCHM} = 'ditch mouth(s)';
	$dsg{DVD} = 'divide';
	$dsg{DCK} = 'dock';
	$dsg{DCKY} = 'dockyard';
	$dsg{BSND} = 'drainage basin';
	$dsg{DTCHD} = 'drainage ditch';
	$dsg{DCKD} = 'dry dock';
	$dsg{SBED} = 'dry stream bed';
	$dsg{DUNE} = 'dune(s)';
	$dsg{RGNE} = 'economic region';
	$dsg{SCRP} = 'escarpment';
	$dsg{EST} = 'estate(s)';
	$dsg{ESTY} = 'estuary';
	$dsg{FCL} = 'facility';
	$dsg{MFG} = 'factory';
	$dsg{FAN} = 'fan(s)';
	$dsg{PPLF} = 'farm village';
	$dsg{FRM} = 'farm(s)';
	$dsg{FY} = 'ferry';
	$dsg{FYT} = 'ferry terminal ';
	$dsg{FLD} = 'field(s)';
	$dsg{FIN} = 'financial institution';
	$dsg{FIRE} = 'fire station';
	$dsg{RNGA} = 'firing range';
	$dsg{ADM1} = 'first-order administrative division';
	$dsg{FISH} = 'fishing area';
	$dsg{PNDSF} = 'fishponds';
	$dsg{FSR} = 'fissure';
	$dsg{FJD} = 'fjord(s)';
	$dsg{FORD} = 'ford';
	$dsg{RESF} = 'forest reserve';
	$dsg{STNF} = 'forest station';
	$dsg{FRST} = 'forest(s)';
	$dsg{MLSGQ} = 'former sugar mill';
	$dsg{FT} = 'fort';
	$dsg{FRSTF} = 'fossilized forest';
	$dsg{FNDY} = 'foundry';
	$dsg{ADM4} = 'fourth-order administrative division';
	$dsg{ZNF} = 'free trade zone';
	$dsg{DPOF} = 'fuel depot';
	$dsg{GAP} = 'gap';
	$dsg{GDN} = 'garden(s)';
	$dsg{GOSP} = 'gas-oil separator plant';
	$dsg{GASF} = 'gasfield';
	$dsg{GATE} = 'gate';
	$dsg{GYSR} = 'geyser';
	$dsg{GHAT} = 'gh&#257;t';
	$dsg{GLCR} = 'glacier(s)';
	$dsg{MNAU} = 'gold mine(s)';
	$dsg{RECG} = 'golf course';
	$dsg{GRGE} = 'gorge(s)';
	$dsg{GRSLD} = 'grassland';
	$dsg{GRVE} = 'grave';
	$dsg{GVL} = 'gravel area';
	$dsg{GRAZ} = 'grazing area';
	$dsg{GROVE} = 'grove';
	$dsg{GHSE} = 'guest house';
	$dsg{GULF} = 'gulf';
	$dsg{HLT} = 'halting place';
	$dsg{HMCK} = 'hammock(s)';
	$dsg{AIRG} = 'hangar';
	$dsg{VALG} = 'hanging valley';
	$dsg{HBR} = 'harbor(s)';
	$dsg{HDLD} = 'headland';
	$dsg{STMH} = 'headwaters';
	$dsg{HTH} = 'heath';
	$dsg{AIRH} = 'heliport';
	$dsg{HERM} = 'hermitage';
	$dsg{HLL} = 'hill';
	$dsg{HLLS} = 'hills';
	$dsg{ADMDH} = 'historical administrative division';
	$dsg{ADM1H} = 'historical first-order administrative division';
	$dsg{ADM4H} = 'historical fourth-order administrative division';
	$dsg{PCLH} = 'historical political entity';
	$dsg{PPLH} = 'historical populated place';
	$dsg{RRH} = 'historical railroad';
	$dsg{RSTNH} = 'historical railroad station';
	$dsg{RGNH} = 'historical region';
	$dsg{ADM2H} = 'historical second-order administrative division';
	$dsg{HSTS} = 'historical site';
	$dsg{ADM3H} = 'historical third-order administrative division';
	$dsg{UFHU} = 'historical undersea feature';
	$dsg{HMSD} = 'homestead';
	$dsg{HSP} = 'hospital';
	$dsg{SPNT} = 'hot spring(s)';
	$dsg{HTL} = 'hotel';
	$dsg{HSE} = 'house(s)';
	$dsg{DEVH} = 'housing development';
	$dsg{RESH} = 'hunting reserve';
	$dsg{HUT} = 'hut(s)';
	$dsg{PSH} = 'hydroelectric power station';
	$dsg{CAPG} = 'icecap';
	$dsg{DPRG} = 'icecap depression';
	$dsg{DOMG} = 'icecap dome';
	$dsg{RDGG} = 'icecap ridge';
	$dsg{PCLI} = 'independent political entity';
	$dsg{INDS} = 'industrial area';
	$dsg{INLT} = 'inlet';
	$dsg{STNI} = 'inspection station';
	$dsg{TRGD} = 'interdune trough(s)';
	$dsg{INTF} = 'interfluve';
	$dsg{LKI} = 'intermittent lake(s)';
	$dsg{LKOI} = 'intermittent oxbow lake';
	$dsg{PNDI} = 'intermittent pond(s)';
	$dsg{POOLI} = 'intermittent pool';
	$dsg{RSVI} = 'intermittent reservoir';
	$dsg{LKNI} = 'intermittent salt lake(s)';
	$dsg{PNDNI} = 'intermittent salt pond(s)';
	$dsg{STMI} = 'intermittent stream';
	$dsg{WTLDI} = 'intermittent wetland';
	$dsg{RDIN} = 'intersection';
	$dsg{MNFE} = 'iron mine(s)';
	$dsg{FLDI} = 'irrigated field(s)';
	$dsg{DTCHI} = 'irrigation ditch';
	$dsg{SYSI} = 'irrigation system';
	$dsg{ISL} = 'island';
	$dsg{ISLS} = 'islands';
	$dsg{STLMT} = 'Israeli settlement';
	$dsg{ISTH} = 'isthmus';
	$dsg{JTY} = 'jetty';
	$dsg{KRST} = 'karst area';
	$dsg{CMPLA} = 'labor camp';
	$dsg{LGN} = 'lagoon(s)';
	$dsg{LK} = 'lake';
	$dsg{LBED} = 'lake bed(s)';
	$dsg{CHNL} = 'lake channel(s)';
	$dsg{RGNL} = 'lake region';
	$dsg{LKS} = 'lakes';
	$dsg{ISLT} = 'land-tied island';
	$dsg{LNDF} = 'landfill';
	$dsg{LDNG} = 'landing';
	$dsg{LAVA} = 'lava area';
	$dsg{MNPB} = 'lead mine(s)';
	$dsg{LTER} = 'leased area';
	$dsg{LEPC} = 'leper colony';
	$dsg{HSPL} = 'leprosarium';
	$dsg{LEV} = 'levee';
	$dsg{LTHSE} = 'lighthouse';
	$dsg{MFGLM} = 'limekiln';
	$dsg{LCTY} = 'locality';
	$dsg{LOCK} = 'lock(s)';
	$dsg{CMPL} = 'logging camp';
	$dsg{STMSB} = 'lost river';
	$dsg{MVA} = 'maneuver area';
	$dsg{ISLM} = 'mangrove island';
	$dsg{MGV} = 'mangrove swamp';
	$dsg{MAR} = 'marina';
	$dsg{CHNM} = 'marine channel';
	$dsg{SCHN} = 'maritime school';
	$dsg{MKT} = 'market';
	$dsg{MRSH} = 'marsh(es)';
	$dsg{MDW} = 'meadow';
	$dsg{NKM} = 'meander neck';
	$dsg{CTRM} = 'medical center';
	$dsg{MESA} = 'mesa(s)';
	$dsg{STNM} = 'meteorological station';
	$dsg{INSM} = 'military installation';
	$dsg{SCHM} = 'military school';
	$dsg{ML} = 'mill(s)';
	$dsg{MN} = 'mine(s)';
	$dsg{MNA} = 'mining area';
	$dsg{CMPMN} = 'mining camp';
	$dsg{MSSN} = 'mission';
	$dsg{MOLE} = 'mole';
	$dsg{MSTY} = 'monastery';
	$dsg{MNMT} = 'monument';
	$dsg{MOOR} = 'moor(s)';
	$dsg{MRN} = 'moraine';
	$dsg{MSQE} = 'mosque';
	$dsg{MND} = 'mound(s)';
	$dsg{MT} = 'mountain';
	$dsg{MTS} = 'mountains';
	$dsg{FLTM} = 'mud flat(s)';
	$dsg{MFGM} = 'munitions plant';
	$dsg{MUS} = 'museum';
	$dsg{NRWS} = 'narrows';
	$dsg{RESN} = 'nature reserve';
	$dsg{NVB} = 'naval base';
	$dsg{CHNN} = 'navigation channel';
	$dsg{MNNI} = 'nickel mine(s)';
	$dsg{NOV} = 'novitiate';
	$dsg{PSN} = 'nuclear power station';
	$dsg{NTK} = 'nunatak';
	$dsg{NTKS} = 'nunataks';
	$dsg{NSY} = 'nursery(-ies)';
	$dsg{OAS} = 'oasis(-es)';
	$dsg{OBPT} = 'observation point';
	$dsg{OBS} = 'observatory';
	$dsg{OCN} = 'ocean';
	$dsg{BLDO} = 'office building';
	$dsg{CMPO} = 'oil camp';
	$dsg{ESTO} = 'oil palm plantation';
	$dsg{OILP} = 'oil pipeline';
	$dsg{OILJ} = 'oil pipeline junction';
	$dsg{TRMO} = 'oil pipeline terminal';
	$dsg{PMPO} = 'oil pumping station';
	$dsg{OILR} = 'oil refinery';
	$dsg{OILW} = 'oil well';
	$dsg{OILF} = 'oilfield';
	$dsg{MLO} = 'olive oil mill';
	$dsg{OCH} = 'orchard(s)';
	$dsg{MLM} = 'ore treatment plant';
	$dsg{OVF} = 'overfalls';
	$dsg{LKO} = 'oxbow lake';
	$dsg{PGDA} = 'pagoda';
	$dsg{PAL} = 'palace';
	$dsg{RESP} = 'palm tree reserve';
	$dsg{PAN} = 'pan';
	$dsg{PANS} = 'pans';
	$dsg{PRSH} = 'parish';
	$dsg{PRK} = 'park';
	$dsg{PRKHQ} = 'park headquarters';
	$dsg{GARG} = 'parking garage';
	$dsg{PKLT} = 'parking lot';
	$dsg{PASS} = 'pass';
	$dsg{PSTP} = 'patrol post';
	$dsg{PK} = 'peak';
	$dsg{PKS} = 'peaks';
	$dsg{PEAT} = 'peat cutting area';
	$dsg{PEN} = 'peninsula';
	$dsg{BSNP} = 'petroleum basin';
	$dsg{MFGPH} = 'phosphate works';
	$dsg{PIER} = 'pier';
	$dsg{MNPL} = 'placer mine(s)';
	$dsg{PLN} = 'plain(s)';
	$dsg{PLAT} = 'plateau';
	$dsg{PT} = 'point(s)';
	$dsg{PLDR} = 'polder';
	$dsg{PP} = 'police post';
	$dsg{PCL} = 'political entity';
	$dsg{PND} = 'pond(s)';
	$dsg{POOL} = 'pool(s)';
	$dsg{PPLL} = 'populated locality';
	$dsg{PPL} = 'populated place';
	$dsg{PRT} = 'port';
	$dsg{PTGE} = 'portage';
	$dsg{PO} = 'post office';
	$dsg{PS} = 'power station';
	$dsg{PRN} = 'prison';
	$dsg{PRMN} = 'promenade';
	$dsg{PROM} = 'promontory(-ies)';
	$dsg{PYR} = 'pyramid(s)';
	$dsg{MNQR} = 'quarry(-ies)';
	$dsg{QUAY} = 'quay';
	$dsg{QCKS} = 'quicksand';
	$dsg{RECR} = 'racetrack';
	$dsg{OBSR} = 'radio observatory';
	$dsg{STNR} = 'radio station';
	$dsg{RR} = 'railroad';
	$dsg{RJCT} = 'railroad junction';
	$dsg{RSD} = 'railroad siding';
	$dsg{RSGNL} = 'railroad signal';
	$dsg{RSTN} = 'railroad station';
	$dsg{RSTP} = 'railroad stop';
	$dsg{TNLRR} = 'railroad tunnel';
	$dsg{RYD} = 'railroad yard';
	$dsg{RNCH} = 'ranch(es)';
	$dsg{RPDS} = 'rapids';
	$dsg{RVN} = 'ravine(s)';
	$dsg{RCH} = 'reach';
	$dsg{RF} = 'reef(s)';
	$dsg{PRNJ} = 'reformatory';
	$dsg{CMPRF} = 'refugee camp';
	$dsg{RGN} = 'region';
	$dsg{CTRR} = 'religious center';
	$dsg{PPLR} = 'religious populated place';
	$dsg{RLG} = 'religious site';
	$dsg{ITTR} = 'research institute';
	$dsg{RESV} = 'reservation';
	$dsg{RES} = 'reserve';
	$dsg{RSV} = 'reservoir(s)';
	$dsg{RSRT} = 'resort';
	$dsg{RHSE} = 'resthouse';
	$dsg{RLGR} = 'retreat';
	$dsg{RDGE} = 'ridge(s)';
	$dsg{RD} = 'road';
	$dsg{RDB} = 'road bend';
	$dsg{RDCUT} = 'road cut';
	$dsg{RDJCT} = 'road junction';
	$dsg{TNLRD} = 'road tunnel';
	$dsg{RDST} = 'roadstead';
	$dsg{RK} = 'rock';
	$dsg{HMDA} = 'rock desert';
	$dsg{RKFL} = 'rockfall';
	$dsg{RKS} = 'rocks';
	$dsg{RKRY} = 'rookery';
	$dsg{ESTR} = 'rubber plantation';
	$dsg{RUIN} = 'ruin(s)';
	$dsg{BDGQ} = 'ruined bridge';
	$dsg{DAMQ} = 'ruined dam';
	$dsg{SBKH} = 'sabkha(s)';
	$dsg{SDL} = 'saddle';
	$dsg{SALT} = 'salt area';
	$dsg{MFGN} = 'salt evaporation ponds';
	$dsg{LKN} = 'salt lake(s)';
	$dsg{MRSHN} = 'salt marsh';
	$dsg{MNN} = 'salt mine(s)';
	$dsg{PNDN} = 'salt pond(s)';
	$dsg{SNTR} = 'sanatorium';
	$dsg{SAND} = 'sand area';
	$dsg{ERG} = 'sandy desert';
	$dsg{STNS} = 'satellite station';
	$dsg{MLSW} = 'sawmill';
	$dsg{SCH} = 'school';
	$dsg{ADMS} = 'school district';
	$dsg{STNB} = 'scientific research base';
	$dsg{SCRB} = 'scrubland';
	$dsg{SEA} = 'sea';
	$dsg{SCNU} = 'seachannel';
	$dsg{SCSU} = 'seachannels';
	$dsg{SMU} = 'seamount';
	$dsg{SMSU} = 'seamounts';
	$dsg{AIRS} = 'seaplane landing area';
	$dsg{PPLA} = 'seat of a first-order administrative division';
	$dsg{PPLA4} = 'seat of a fourth-order administrative division';
	$dsg{PPLA2} = 'seat of a second-order administrative division';
	$dsg{PPLA3} = 'seat of a third-order administrative division';
	$dsg{ADM2} = 'second-order administrative division';
	$dsg{BNKX} = 'section of bank';
	$dsg{CNLX} = 'section of canal';
	$dsg{ESTX} = 'section of estate';
	$dsg{HBRX} = 'section of harbor';
	$dsg{PCLIX} = 'section of independent political entity';
	$dsg{STMIX} = 'section of intermittent stream';
	$dsg{ISLX} = 'section of island';
	$dsg{LGNX} = 'section of lagoon';
	$dsg{LKX} = 'section of lake';
	$dsg{PENX} = 'section of peninsula';
	$dsg{PLNX} = 'section of plain';
	$dsg{PLATX} = 'section of plateau';
	$dsg{PPLX} = 'section of populated place';
	$dsg{RFX} = 'section of reef';
	$dsg{STMX} = 'section of stream';
	$dsg{VALX} = 'section of valley';
	$dsg{WADX} = 'section of wadi';
	$dsg{FLLSX} = 'section of waterfall(s)';
	$dsg{SWT} = 'sewage treatment plant';
	$dsg{SHOL} = 'shoal(s)';
	$dsg{SHOPC} = 'shopping center or mall';
	$dsg{SHOR} = 'shore';
	$dsg{SHRN} = 'shrine';
	$dsg{SINK} = 'sinkhole';
	$dsg{ESTSL} = 'sisal plantation';
	$dsg{SLID} = 'slide';
	$dsg{SLP} = 'slope(s)';
	$dsg{SLCE} = 'sluice';
	$dsg{SNOW} = 'snowfield';
	$dsg{SD} = 'sound';
	$dsg{SPA} = 'spa';
	$dsg{CTRS} = 'space center';
	$dsg{SPLY} = 'spillway';
	$dsg{SPIT} = 'spit';
	$dsg{SPNG} = 'spring(s)';
	$dsg{SPUR} = 'spur(s)';
	$dsg{SQR} = 'square';
	$dsg{STBL} = 'stable';
	$dsg{STDM} = 'stadium';
	$dsg{STPS} = 'steps';
	$dsg{STKR} = 'stock route';
	$dsg{REG} = 'stony desert';
	$dsg{RET} = 'store';
	$dsg{SHSE} = 'storehouse';
	$dsg{STRT} = 'strait';
	$dsg{BNKR} = 'stream bank';
	$dsg{STMB} = 'stream bend';
	$dsg{STMGS} = 'stream gauging station';
	$dsg{STMM} = 'stream mouth(s)';
	$dsg{STM} = 'stream(s)';
	$dsg{ST} = 'street';
	$dsg{DAMSB} = 'sub-surface dam';
	$dsg{SUBW} = 'subway';
	$dsg{SUBS} = 'subway station';
	$dsg{MLSG} = 'sugar mill';
	$dsg{ESTSG} = 'sugar plantation';
	$dsg{MFGSG} = 'sugar refinery';
	$dsg{SPNS} = 'sulphur spring(s)';
	$dsg{SWMP} = 'swamp';
	$dsg{SYG} = 'synagogue';
	$dsg{TMTU} = 'tablemount (or guyot)';
	$dsg{TMSU} = 'tablemounts (or guyots)';
	$dsg{TAL} = 'talus slope';
	$dsg{OILT} = 'tank farm';
	$dsg{ESTT} = 'tea plantation';
	$dsg{SCHT} = 'technical school';
	$dsg{TMPL} = 'temple(s)';
	$dsg{AIRT} = 'terminal';
	$dsg{TRR} = 'terrace';
	$dsg{TERR} = 'territory';
	$dsg{ADM3} = 'third-order administrative division';
	$dsg{CRKT} = 'tidal creek(s)';
	$dsg{FLTT} = 'tidal flat(s)';
	$dsg{MNSN} = 'tin mine(s)';
	$dsg{TOLL} = 'toll gate/barrier';
	$dsg{TMB} = 'tomb(s)';
	$dsg{TOWR} = 'tower';
	$dsg{RDCR} = 'traffic circle';
	$dsg{TRL} = 'trail';
	$dsg{TRANT} = 'transit terminal';
	$dsg{TREE} = 'tree(s)';
	$dsg{TRIG} = 'triangulation station';
	$dsg{TRB} = 'tribal area';
	$dsg{TUND} = 'tundra';
	$dsg{TNL} = 'tunnel(s)';
	$dsg{CNLSB} = 'underground irrigation canal(s)';
	$dsg{LKSB} = 'underground lake';
	$dsg{APNU} = 'undersea apron';
	$dsg{ARCU} = 'undersea arch';
	$dsg{ARRU} = 'undersea arrugado';
	$dsg{BNKU} = 'undersea bank';
	$dsg{BKSU} = 'undersea banks';
	$dsg{BSNU} = 'undersea basin';
	$dsg{BNCU} = 'undersea bench';
	$dsg{BDLU} = 'undersea borderland';
	$dsg{CNYU} = 'undersea canyon';
	$dsg{CNSU} = 'undersea canyons';
	$dsg{CDAU} = 'undersea cordillera';
	$dsg{ESCU} = 'undersea escarpment (or scarp)';
	$dsg{FANU} = 'undersea fan';
	$dsg{FLTU} = 'undersea flat';
	$dsg{FRKU} = 'undersea fork';
	$dsg{FRSU} = 'undersea forks';
	$dsg{FRZU} = 'undersea fracture zone';
	$dsg{FURU} = 'undersea furrow';
	$dsg{GAPU} = 'undersea gap';
	$dsg{GLYU} = 'undersea gully';
	$dsg{HLLU} = 'undersea hill';
	$dsg{HLSU} = 'undersea hills';
	$dsg{HOLU} = 'undersea hole';
	$dsg{KNLU} = 'undersea knoll';
	$dsg{KNSU} = 'undersea knolls';
	$dsg{LDGU} = 'undersea ledge';
	$dsg{LEVU} = 'undersea levee';
	$dsg{MDVU} = 'undersea median valley';
	$dsg{MESU} = 'undersea mesa';
	$dsg{MOTU} = 'undersea moat';
	$dsg{MNDU} = 'undersea mound';
	$dsg{MTU} = 'undersea mountain';
	$dsg{MTSU} = 'undersea mountains';
	$dsg{PKU} = 'undersea peak';
	$dsg{PKSU} = 'undersea peaks';
	$dsg{PNLU} = 'undersea pinnacle';
	$dsg{PLNU} = 'undersea plain';
	$dsg{PLTU} = 'undersea plateau';
	$dsg{PLFU} = 'undersea platform';
	$dsg{PRVU} = 'undersea province';
	$dsg{RMPU} = 'undersea ramp';
	$dsg{RNGU} = 'undersea range';
	$dsg{RAVU} = 'undersea ravine';
	$dsg{RFU} = 'undersea reef';
	$dsg{RFSU} = 'undersea reefs';
	$dsg{RDGU} = 'undersea ridge';
	$dsg{RDSU} = 'undersea ridges';
	$dsg{RISU} = 'undersea rise';
	$dsg{SDLU} = 'undersea saddle';
	$dsg{SHFU} = 'undersea shelf';
	$dsg{EDGU} = 'undersea shelf edge';
	$dsg{SHVU} = 'undersea shelf valley';
	$dsg{SHLU} = 'undersea shoal';
	$dsg{SHSU} = 'undersea shoals';
	$dsg{SILU} = 'undersea sill';
	$dsg{SLPU} = 'undersea slope';
	$dsg{SPRU} = 'undersea spur';
	$dsg{TERU} = 'undersea terrace';
	$dsg{TNGU} = 'undersea tongue';
	$dsg{TRNU} = 'undersea trench';
	$dsg{TRGU} = 'undersea trough';
	$dsg{VALU} = 'undersea valley';
	$dsg{VLSU} = 'undersea valleys';
	$dsg{USGE} = 'United States Government Establishment';
	$dsg{UPLD} = 'upland';
	$dsg{VAL} = 'valley';
	$dsg{VALS} = 'valleys';
	$dsg{VETF} = 'veterinary facility';
	$dsg{VIN} = 'vineyard';
	$dsg{VINS} = 'vineyards';
	$dsg{VLC} = 'volcano';
	$dsg{WADB} = 'wadi bend';
	$dsg{WADJ} = 'wadi junction';
	$dsg{WADM} = 'wadi mouth';
	$dsg{WAD} = 'wadi(s)';
	$dsg{WALL} = 'wall';
	$dsg{MLWTR} = 'water mill';
	$dsg{PMPW} = 'water pumping station';
	$dsg{RSVT} = 'water tank';
	$dsg{WLL} = 'water well(s)';
	$dsg{FLLS} = 'waterfall(s)';
	$dsg{WTRH} = 'waterhole(s)';
	$dsg{WTRW} = 'waterworks';
	$dsg{WEIR} = 'weir(s)';
	$dsg{WTLD} = 'wetland';
	$dsg{STNW} = 'whaling station';
	$dsg{WHRF} = 'wharf(-ves)';
	$dsg{WHRL} = 'whirlpool';
	$dsg{RESW} = 'wildlife reserve';
	$dsg{MLWND} = 'windmill';
	$dsg{WRCK} = 'wreck';
	$dsg{ZOO} = 'zoo';
	$fc{A} = 'A - Administrative Region';
	$fc{H} = 'H - Hydrographic';
	$fc{L} = 'L - Area';
	$fc{P} = 'P - Populated Place';
	$fc{R} = 'R - Streets/Highways/Roads';
	$fc{S} = 'S - Spot Features';
	$fc{T} = 'T - Hypsographic';
	$fc{U} = 'U - Undersea';
	$fc{V} = 'V - Vegetation';
}
